<?php
      
if (!defined('TL_ROOT')) die('You can not access this file directly!');

/**
 * TYPOlight webCMS
 *
 * The TYPOlight webCMS is an accessible web content management system that 
 * specializes in accessibility and generates W3C-compliant HTML code. It 
 * provides a wide range of functionality to develop professional websites 
 * including a built-in search engine, form generator, file and user manager, 
 * CSS engine, multi-language support and many more. For more information and 
 * additional TYPOlight applications like the TYPOlight MVC Framework please 
 * visit the project website http://www.typolight.org.
 *
 */


/**
 * @filesource: http://www.mediensozialismus.de
 * @license: GPL
 * based on CdCollection by Leo Feyer
 */

class ModuleVoteSite extends Module
{

	/**
	 * Template file
	 * @var string
	 */
	protected $strTemplate = 'mod_votesite';

	/**
	 * Get all records and add them to an array
	 */
	protected function compile()
	{
		$limit = null;
		$arrvotesite = array();

		 
		
		if ($this->perPage > 0)
		{
			$page = $this->Input->get('page') ? $this->Input->get('page') : 1;
			$limit = $this->perPage;
			$offset = ($page - 1) * $this->perPage;

			// Get total number of comments
			$objTotal = $this->Database->prepare("SELECT COUNT(*) AS count FROM tl_votesite")
									   ->execute($this->id, 1);

			// Add pagination menu
			$objPagination = new Pagination($objTotal->count, $this->perPage);
			$this->Template->pagination = $objPagination->generate("\n  ");
		}
    
		// Get all published comments
		$arrvotesite = array();
		$objvotesite = $this->Database->prepare("SELECT * FROM tl_votesite ORDER BY tstamp DESC");
		
		if ($limit)
		{
			$objvotesite->limit($limit, $offset);
		}

		$objvotesite = $objvotesite->execute($this->id, 1);

		if ($objvotesite->numRows)
		{
			$count = 0;
			$objTemplate = new FrontendTemplate($this->com_template);
		
		while ($objvotesite->next())
		{
			$arrvotesite[] = array
			(
				'site' => $objvotesite->site,
				'src' => 'image.php?src=' . $objvotesite->image,
				'alt' => specialchars($objvotesite->site),
				'id' => $objvotesite->id,
				'total_votes' => $objvotesite->total_votes,
				'total_value' => $objvotesite->total_value,
				'used_ips' => $objvotesite->used_ips,
				'star' => $objvotesite->star,
				'name' => $objvotesite->name,
				'text' => $objvotesite->text,
			);
		}

		$this->Template->votesite = $arrvotesite; 
		}
	}
}

function rating_bar($id,$units='',$static='') { 

$rating_unitwidth     = 20;  

//set some variables
$ip = $_SERVER['REMOTE_ADDR'];
if (!$units) {$units = 10;}
if (!$static) {$static = FALSE;}

// get votes, values, ips for the current rating bar
$query=mysql_query("SELECT total_votes, total_value, used_ips FROM tl_votesite WHERE id='$id' ")or die(" Error: ".mysql_error());

$numbers=mysql_fetch_assoc($query);


if ($numbers['total_votes'] < 1) {
	$count = 0;
} else {
	$count=$numbers['total_votes']; //how many votes total
}
$current_rating=$numbers['total_value']; //total number of rating added together and stored
$tense=($count==1) ? "vote" : "votes"; //plural form votes/vote

// determine whether the user has voted, so we know how to draw the ul/li
$voted=mysql_num_rows(mysql_query("SELECT used_ips FROM tl_votesite WHERE used_ips LIKE '%".$ip."%' AND id='".$id."' ")); 

// now draw the rating bar
$rating_width = @number_format($current_rating/$count,2)*$rating_unitwidth;
$rating1 = @number_format($current_rating/$count,2);
$rating2 = @number_format($current_rating/$count,2);

if ($static == 'static') {

		$static_rater = array();
		$static_rater[] .= "\n".'<div class="ratingblock">';
		$static_rater[] .= '<div id="unit_long'.$id.'">';
		$static_rater[] .= '<ul id="unit_ul'.$id.'" class="unit-rating" style="width:'.$rating_unitwidth*$units.'px;">';
		$static_rater[] .= '<li class="current-rating" style="width:'.$rating_width.'px;">Currently '.$rating2.'/'.$units.'</li>';
		$static_rater[] .= '</ul>';
		$static_rater[] .= '<p class="static">'.$id.'.Rating: <strong> '.$rating1.'</strong>/'.$units.' ('.$count.' '.$tense.' cast) <em>This is \'static\'.</em></p>';
		$static_rater[] .= '</div>';
		$static_rater[] .= '</div>'."\n\n";

		return join("\n", $static_rater);


} else {
	  
      $rater ='';
      $rater.='<div class="ratingblock">';

      $rater.='<div id="unit_long'.$id.'">';
      $rater.='  <ul id="unit_ul'.$id.'" class="unit-rating" style="width:'.$rating_unitwidth*$units.'px;">';
      $rater.='     <li class="current-rating" style="width:'.$rating_width.'px;">Currently '.$rating2.'/'.$units.'</li>';

      for ($ncount = 1; $ncount <= $units; $ncount++) { // loop from 1 to the number of units
           if(!$voted) { // if the user hasn't yet voted, draw the voting stars
              $rater.='<li><a href="index.php/home.html?d=1&amp;j='.$ncount.'&amp;q='.$id.'&amp;t='.$ip.'&amp;c='.$units.'" title="'.$ncount.' out of '.$units.'" class="r'.$ncount.'-unit rater" rel="nofollow">'.$ncount.'</a></li>';
       	 }
      }
$ncount=0; // resets the count

      $rater.='  </ul>';
      $rater.='  <p';
      if($voted){ $rater.=' class="voted"'; }
      $rater.='>Rating: <strong> '.$rating1.'</strong>';
      $rater.='  </p>';
      $rater.='</div>';
      $rater.='</div>';
      return $rater;
			}
		}

//DB und RPC Schnittstellen

//getting the values
$vote_sent = preg_replace("/[^0-9]/","",$_REQUEST['j']);
$id_sent = preg_replace("/[^0-9a-zA-Z]/","",$_REQUEST['q']);
$ip_num = preg_replace("/[^0-9\.]/","",$_REQUEST['t']);
$units = preg_replace("/[^0-9]/","",$_REQUEST['c']);
$ip = $_SERVER['REMOTE_ADDR'];
$referer  = $_SERVER['HTTP_REFERER'];

//if ($vote_sent > $units) die("Sorry, vote appears to be invalid."); // kill the script because normal users will never see this.

//connecting to the database to get some information
$query = mysql_query("SELECT total_votes, total_value, used_ips FROM tl_votesite WHERE id='$id_sent' ")or die(" Error: ".mysql_error());
$numbers = mysql_fetch_assoc($query);
$checkIP = unserialize($numbers['used_ips']);
$count = $numbers['total_votes']; //how many votes total
$current_rating = $numbers['total_value']; //total number of rating added together and stored
$sum = $vote_sent+$current_rating; // add together the current vote value and the total vote value
$tense = ($count==1) ? "vote" : "votes"; //plural form votes/vote

// checking to see if the first vote has been tallied
// or increment the current number of votes
($sum==0 ? $added=0 : $added=$count+1);

// if it is an array i.e. already has entries the push in another value
((is_array($checkIP)) ? array_push($checkIP,$ip_num) : $checkIP=array($ip_num));
$insertip=serialize($checkIP);

		while($_GET['d'] == '1')
		{
			header("Cache-Control: no-cache");
			header("Pragma: nocache");
			
			//IP check when voting
			$voted=mysql_num_rows(mysql_query("SELECT used_ips FROM tl_votesite WHERE used_ips LIKE '%".$ip."%' AND id='".$id_sent."' "));
			if(!$voted) {     //if the user hasn't yet voted, then vote normally...


			if (($vote_sent >= 1 && $vote_sent <= $units) && ($ip == $ip_num)) { // keep votes within range
			$update = "UPDATE tl_votesite SET total_votes='".$added."', total_value='".$sum."', used_ips='".$insertip."' WHERE id='$id_sent'";
			$result = mysql_query($update);		
			} 

			} //end for the "if(!$voted)"

			header("Location: $referer"); // go back to the page we came from 
			exit;
		}	

		while($_GET['d'] == '2')
		{
			header("Cache-Control: no-cache");
			header("Pragma: nocache");
			
			$rating_unitwidth     = 20;
			
			//IP check when voting
			$voted=mysql_num_rows(mysql_query("SELECT used_ips FROM tl_votesite WHERE used_ips LIKE '%".$ip."%' AND id='".$id_sent."' "));
			if(!$voted) {     //if the user hasn't yet voted, then vote normally...

			if (($vote_sent >= 1 && $vote_sent <= $units) && ($ip == $ip_num)) { // keep votes within range, make sure IP matches - no monkey business!
			$update = "UPDATE tl_votesite SET total_votes='".$added."', total_value='".$sum."', used_ips='".$insertip."' WHERE id='$id_sent'";
			$result = mysql_query($update);		
			} 
			} //end for the "if(!$voted)"
			// these are new queries to get the new values!
			$newtotals = mysql_query("SELECT total_votes, total_value, used_ips FROM tl_votesite WHERE id='$id_sent' ")or die(" Error: ".mysql_error());
			$numbers = mysql_fetch_assoc($newtotals);
			$count = $numbers['total_votes'];//how many votes total
			$current_rating = $numbers['total_value'];//total number of rating added together and stored
			$tense = ($count==1) ? "vote" : "votes"; //plural form votes/vote

			// $new_back is what gets 'drawn' on your page after a successful 'AJAX/Javascript' vote

			$new_back = array();

			$new_back[] .= '<ul class="unit-rating" style="width:'.$units*$rating_unitwidth.'px;">';
			$new_back[] .= '<li class="current-rating" style="width:'.@number_format($current_rating/$count,2)*$rating_unitwidth.'px;">Current rating.</li>';
			$new_back[] .= '<li class="r1-unit">1</li>';
			$new_back[] .= '<li class="r2-unit">2</li>';
			$new_back[] .= '<li class="r3-unit">3</li>';
			$new_back[] .= '<li class="r4-unit">4</li>';
			$new_back[] .= '<li class="r5-unit">5</li>';
			$new_back[] .= '<li class="r6-unit">6</li>';
			$new_back[] .= '<li class="r7-unit">7</li>';
			$new_back[] .= '<li class="r8-unit">8</li>';
			$new_back[] .= '<li class="r9-unit">9</li>';
			$new_back[] .= '<li class="r10-unit">10</li>';
			$new_back[] .= '</ul>';
			$new_back[] .= '<p class="voted"> Rating: <strong>'.@number_format($sum/$added,2).'</strong></p>';
			$new_back[] .= '';
	
			$allnewback = join("\n", $new_back);

			// ========================

			//name of the div id to be updated | the html that needs to be changed
			$output = "unit_long$id_sent|$allnewback";
			echo $output;
			exit;
		}
 
 
 ?>